/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.command;

import com.ibm.hsc.client.HSCCECClient;
import com.ibm.hsc.client.HSCClientObjectFactory;
import com.ibm.hsc.client.HSCConsoleClient;
import com.ibm.hsc.client.HSCFrameClient;
import com.ibm.hsc.client.HSCLPARClient;
import com.ibm.hsc.client.HSCProfileClient;
import com.ibm.hsc.client.HSCSystemProfileClient;
import com.ibm.hsc.command.ControllerThread;
import com.ibm.hsc.command.HMCCommandUtils;
import com.ibm.hsc.command.HMCCommands;
import com.ibm.hsc.command.HMCFormatTable;
import com.ibm.hsc.common.bundles.HSCResourceBundleUtil;
import com.ibm.hsc.common.exceptions.HSCException;
import com.ibm.hsc.common.exceptions.RequiredParameterException;
import com.ibm.hsc.websm.frame.CSPStateText;
import com.ibm.websm.diagnostics.IDebug;
import java.io.PrintStream;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;

public class SystemConfigurationList
implements HMCCommands {
    private static final char GOOD_STATUS = '\u0000';
    private static final char ERROR_STATUS = '\u0001';
    private Hashtable resultTable;
    private HSCCECClient hcc;
    private HSCConsoleClient consoleClient;
    private HSCFrameClient hfc;
    private HSCLPARClient hlc;
    private HSCProfileClient hpc;
    private HSCSystemProfileClient hspc;
    private List outputList = null;
    private String allResources;
    private String alternateFormat;
    private String format;
    private String frameName;
    private String managedSystem;
    private String name;
    private String resourceType;
    private String sourcePartition;
    private Vector cecClients;
    private Vector frameClients;
    private Vector lparClients;
    private Vector profileClients;
    private Vector systemProfileClients;
    private boolean oldCommand = false;
    private boolean writeStatus;
    private PrintStream output;

    public SystemConfigurationList(boolean bl) {
        if (bl) {
            this.writeStatus = false;
            this.output = System.out;
        } else {
            this.writeStatus = true;
            this.output = ((ControllerThread)Thread.currentThread()).getOutputStream();
        }
    }

    private void checkRequiredParameters() throws HSCException, RequiredParameterException {
        String string = null;
        String string2 = null;
        Object[] objectArray = null;
        String string3 = HMCCommandUtils.RESOURCE_TYPE_PARAM + " " + HSCResourceBundleUtil.getMessage("HSCCommonBundle", "AND", "and", null) + " (" + HMCCommandUtils.NAME_PARAM + " " + HSCResourceBundleUtil.getMessage("HSCCommonBundle", "OR", "or", null) + " " + HMCCommandUtils.ALL_PARAM + ")";
        String string4 = HMCCommandUtils.RESOURCE_TYPE_PARAM + ", " + HMCCommandUtils.MANAGED_SYSTEM_PARAM + " " + HSCResourceBundleUtil.getMessage("HSCCommonBundle", "AND", "and", null) + " (" + HMCCommandUtils.NAME_PARAM + " " + HSCResourceBundleUtil.getMessage("HSCCommonBundle", "OR", "or", null) + " " + HMCCommandUtils.ALL_PARAM + ")";
        String string5 = HMCCommandUtils.RESOURCE_TYPE_PARAM + ", " + HMCCommandUtils.MANAGED_SYSTEM_PARAM + ", " + HMCCommandUtils.SOURCE_PARTITION_NAME_PARAM + ", " + HSCResourceBundleUtil.getMessage("HSCCommonBundle", "AND", "and", null) + " (" + HMCCommandUtils.NAME_PARAM + " " + HSCResourceBundleUtil.getMessage("HSCCommonBundle", "OR", "or", null) + " " + HMCCommandUtils.ALL_PARAM + ")";
        if (!(null != this.name || null != this.allResources || this.resourceType != null && this.resourceType.equals(HMCCommandUtils.ALL_TYPE))) {
            objectArray = new String[]{string3};
            string = new String("The command entered is either missing a required parameter or a parameter value is invalid. The required parameters for this command is " + string3 + ". Please check your entry and retry the command.");
            string2 = HSCResourceBundleUtil.getMessage("HSCCommonBundle", "COMMAND_LINE_ERROR_REQUIRED_PARAMETERS", string, objectArray);
            throw new RequiredParameterException(string2);
        }
        if ((this.resourceType.equals(HMCCommandUtils.PARTITION_TYPE) || this.resourceType.equals(HMCCommandUtils.AFFINITY_PARTITION_TYPE) || this.resourceType.equals(HMCCommandUtils.SYSTEM_PROFILE_TYPE)) && null == this.managedSystem) {
            objectArray = new String[]{string4};
            string = new String("The command entered is either missing a required parameter or a parameter value is invalid. The required parameters for this command is " + string4 + ". Please check your entry and retry the command.");
            string2 = HSCResourceBundleUtil.getMessage("HSCCommonBundle", "COMMAND_LINE_ERROR_REQUIRED_PARAMETERS", string, objectArray);
            throw new RequiredParameterException(string2);
        }
        if (this.resourceType.equals(HMCCommandUtils.PROFILE_TYPE) && (null == this.sourcePartition || null == this.managedSystem)) {
            objectArray = new String[]{string5};
            string = new String("The command entered is either missing a required parameter or a parameter value is invalid. The required parameters for this command is " + string5 + ". Please check your entry and retry the command.");
            string2 = HSCResourceBundleUtil.getMessage("HSCCommonBundle", "COMMAND_LINE_ERROR_REQUIRED_PARAMETERS", string, objectArray);
            throw new RequiredParameterException(string2);
        }
        if (this.format != null && this.alternateFormat != null) {
            objectArray = new String[]{string5};
            string = new String("An error occurred while performing this command. The " + HMCCommandUtils.FORMAT_PARAM + " cannot be used " + " with the " + HMCCommandUtils.ALTERNATE_FORMAT_PARAM + "." + ". Please check your entry and retry the command.");
            string2 = HSCResourceBundleUtil.getMessage("HSCCommonBundle", "COMMAND_LINE_ERROR_REQUIRED_PARAMETERS", string, objectArray);
            throw new RequiredParameterException(string2);
        }
    }

    private void validateParameterValues() throws RequiredParameterException {
        String string = null;
        String string2 = null;
        Object[] objectArray = null;
        if (!(this.resourceType.equals(HMCCommandUtils.ALL_TYPE) || this.resourceType.equals(HMCCommandUtils.AFFINITY_PARTITION_TYPE) || this.resourceType.equals(HMCCommandUtils.FRAME_TYPE) || this.resourceType.equals(HMCCommandUtils.PARTITION_TYPE) || this.resourceType.equals(HMCCommandUtils.PROFILE_TYPE) || this.resourceType.equals(HMCCommandUtils.SYSTEM_PROFILE_TYPE) || this.resourceType.equals(HMCCommandUtils.SYSTEM_TYPE))) {
            objectArray = new String[]{HMCCommandUtils.RESOURCE_TYPE_PARAM, HMCCommandUtils.ALL_TYPE + ", " + HMCCommandUtils.AFFINITY_PARTITION_TYPE + ", " + HMCCommandUtils.FRAME_TYPE + ", " + HMCCommandUtils.PARTITION_TYPE + ", " + HMCCommandUtils.PROFILE_TYPE + ", " + HMCCommandUtils.SYSTEM_PROFILE_TYPE + " " + HSCResourceBundleUtil.getMessage("HSCCommonBundle", "AND", "and", null) + " " + HMCCommandUtils.SYSTEM_TYPE};
            string = "There is an invalid parameter value. The valid values for " + HMCCommandUtils.RESOURCE_TYPE_PARAM + " are " + HMCCommandUtils.ALL_TYPE + ", " + HMCCommandUtils.AFFINITY_PARTITION_TYPE + ", " + HMCCommandUtils.FRAME_TYPE + ", " + HMCCommandUtils.PARTITION_TYPE + ", " + HMCCommandUtils.PROFILE_TYPE + ", " + HMCCommandUtils.SYSTEM_PROFILE_TYPE + " and " + HMCCommandUtils.SYSTEM_TYPE + ". Please retry command.";
            string2 = HSCResourceBundleUtil.getMessage("HSCCommonBundle", "COMMAND_LINE_ERROR_GENERAL_INVALID_PARAMETER_VALUE", string, objectArray);
            throw new RequiredParameterException(string2);
        }
    }

    private void initializeClients() throws HSCException {
        block53: {
            int n;
            Vector vector;
            Vector vector2;
            Vector vector3;
            Vector vector4;
            Vector vector5;
            String string;
            String string2;
            String string3;
            HSCSystemProfileClient hSCSystemProfileClient;
            HSCProfileClient hSCProfileClient;
            HSCLPARClient hSCLPARClient;
            HSCFrameClient hSCFrameClient;
            HSCCECClient hSCCECClient;
            HSCClientObjectFactory hSCClientObjectFactory;
            Hashtable hashtable;
            block52: {
                Object object;
                hashtable = null;
                hSCClientObjectFactory = null;
                hSCCECClient = null;
                hSCFrameClient = null;
                hSCLPARClient = null;
                hSCProfileClient = null;
                hSCSystemProfileClient = null;
                InetAddress inetAddress = null;
                string3 = null;
                string2 = null;
                string = null;
                vector5 = null;
                vector4 = null;
                vector3 = null;
                vector2 = null;
                vector = null;
                try {
                    inetAddress = InetAddress.getLocalHost();
                    string2 = inetAddress.getHostName();
                }
                catch (Exception exception) {
                    throw new HSCException(exception);
                }
                hSCClientObjectFactory = HSCClientObjectFactory.getInstance(string2, null);
                if (!this.resourceType.equals(HMCCommandUtils.ALL_TYPE)) break block52;
                this.consoleClient = hSCClientObjectFactory.createConsoleClient();
                vector4 = this.consoleClient.getFrameNames();
                this.frameClients = new Vector();
                int n2 = 0;
                while (n2 < vector4.size()) {
                    string = (String)vector4.elementAt(n2);
                    hSCFrameClient = hSCClientObjectFactory.createFrameClient(string2, string);
                    if (hSCFrameClient == null) {
                        string3 = HSCResourceBundleUtil.getMessage("HSCCommonBundle", "FRAME_NOT_FOUND");
                        throw new HSCException(string3);
                    }
                    this.frameClients.add(hSCFrameClient);
                    ++n2;
                }
                vector5 = this.consoleClient.getCecNames();
                this.cecClients = new Vector();
                int n3 = 0;
                while (n3 < vector5.size()) {
                    string = (String)vector5.elementAt(n3);
                    hSCCECClient = hSCClientObjectFactory.createCECClient(string, false);
                    if (hSCCECClient == null) {
                        string3 = HSCResourceBundleUtil.getMessage("HSCCommonBundle", "MANAGED_SYSTEM_NOT_FOUND");
                        throw new HSCException(string3);
                    }
                    this.cecClients.add(hSCCECClient);
                    ++n3;
                }
                this.systemProfileClients = new Vector();
                Enumeration enumeration = this.cecClients.elements();
                while (enumeration.hasMoreElements()) {
                    hSCCECClient = (HSCCECClient)enumeration.nextElement();
                    vector = hSCCECClient.getSystemProfileNames();
                    object = hSCCECClient.getUserDefinedName();
                    int n4 = 0;
                    while (n4 < vector.size()) {
                        string = (String)vector.elementAt(n4);
                        hSCSystemProfileClient = hSCClientObjectFactory.createSystemProfileClient((String)object, string, false);
                        if (hSCSystemProfileClient == null) {
                            string3 = HSCResourceBundleUtil.getMessage("HSCCommonBundle", "SYSTEM_PROFILE_NOT_FOUND");
                            throw new HSCException(string3);
                        }
                        this.systemProfileClients.add(hSCSystemProfileClient);
                        ++n4;
                    }
                }
                this.lparClients = new Vector();
                object = this.cecClients.elements();
                while (object.hasMoreElements()) {
                    hSCCECClient = (HSCCECClient)object.nextElement();
                    hashtable = hSCCECClient.getLparNames();
                    vector3 = (Vector)hashtable.get("LparName");
                    String string4 = hSCCECClient.getUserDefinedName();
                    int n5 = 0;
                    while (n5 < vector3.size()) {
                        string = (String)vector3.elementAt(n5);
                        hSCLPARClient = hSCClientObjectFactory.createLPARClient(string4, string, false);
                        if (hSCLPARClient == null) {
                            string3 = HSCResourceBundleUtil.getMessage("HSCCommonBundle", "MANAGED_SYSTEM_NOT_FOUND");
                            throw new HSCException(string3);
                        }
                        this.lparClients.add(hSCLPARClient);
                        ++n5;
                    }
                    vector3 = (Vector)hashtable.get("AlparName");
                    int n6 = 0;
                    while (n6 < vector3.size()) {
                        string = (String)vector3.elementAt(n6);
                        hSCLPARClient = hSCClientObjectFactory.createLPARClient(string4, string, false);
                        if (hSCLPARClient == null) {
                            string3 = HSCResourceBundleUtil.getMessage("HSCCommonBundle", "MANAGED_SYSTEM_NOT_FOUND");
                            throw new HSCException(string3);
                        }
                        this.lparClients.add(hSCLPARClient);
                        ++n6;
                    }
                }
                this.profileClients = new Vector();
                Enumeration enumeration2 = this.lparClients.elements();
                while (enumeration2.hasMoreElements()) {
                    HSCLPARClient hSCLPARClient2 = (HSCLPARClient)enumeration2.nextElement();
                    vector2 = hSCLPARClient2.getProfileNames();
                    String string5 = hSCCECClient.getUserDefinedName();
                    String string6 = hSCLPARClient2.getUserDefinedName();
                    int n7 = 0;
                    while (n7 < vector2.size()) {
                        string = (String)vector2.elementAt(n7);
                        hSCProfileClient = hSCClientObjectFactory.createProfileClient(string5, string6, string, false);
                        if (hSCProfileClient == null) {
                            string3 = HSCResourceBundleUtil.getMessage("HSCCommonBundle", "PROFILE_NOT_FOUND");
                            throw new HSCException(string3);
                        }
                        this.profileClients.add(hSCProfileClient);
                        ++n7;
                    }
                }
                break block53;
            }
            if (this.resourceType.equals(HMCCommandUtils.FRAME_TYPE)) {
                if (null == this.allResources) {
                    this.hfc = hSCClientObjectFactory.createFrameClient(string2, this.name);
                    if (null == this.hfc) {
                        string3 = HSCResourceBundleUtil.getMessage("HSCCommonBundle", "FRAME_NOT_FOUND");
                        throw new HSCException(string3);
                    }
                } else {
                    this.consoleClient = hSCClientObjectFactory.createConsoleClient();
                    vector4 = this.consoleClient.getFrameNames();
                    this.frameClients = new Vector();
                    n = 0;
                    while (n < vector4.size()) {
                        string = (String)vector4.elementAt(n);
                        hSCFrameClient = hSCClientObjectFactory.createFrameClient(string2, string);
                        if (hSCFrameClient == null) {
                            string3 = HSCResourceBundleUtil.getMessage("HSCCommonBundle", "FRAME_NOT_FOUND");
                            throw new HSCException(string3);
                        }
                        this.frameClients.add(hSCFrameClient);
                        ++n;
                    }
                }
            }
            if (this.resourceType.equals(HMCCommandUtils.SYSTEM_TYPE)) {
                if (null == this.allResources) {
                    this.hcc = hSCClientObjectFactory.createCECClient(this.name, false);
                    if (null == this.hcc) {
                        string3 = HSCResourceBundleUtil.getMessage("HSCCommonBundle", "MANAGED_SYSTEM_NOT_FOUND");
                        throw new HSCException(string3);
                    }
                } else if (null != this.frameName) {
                    this.hfc = hSCClientObjectFactory.createFrameClient(this.frameName);
                    if (null == this.hfc) {
                        string3 = HSCResourceBundleUtil.getMessage("HSCCommonBundle", "FRAME_NOT_FOUND");
                        throw new HSCException(string3);
                    }
                } else {
                    this.consoleClient = hSCClientObjectFactory.createConsoleClient();
                    vector5 = this.consoleClient.getCecNames();
                    this.cecClients = new Vector();
                    n = 0;
                    while (n < vector5.size()) {
                        string = (String)vector5.elementAt(n);
                        hSCCECClient = hSCClientObjectFactory.createCECClient(string, false);
                        if (hSCCECClient == null) {
                            string3 = HSCResourceBundleUtil.getMessage("HSCCommonBundle", "MANAGED_SYSTEM_NOT_FOUND");
                            throw new HSCException(string3);
                        }
                        this.cecClients.add(hSCCECClient);
                        ++n;
                    }
                }
            }
            if (this.resourceType.equals(HMCCommandUtils.PARTITION_TYPE) || this.resourceType.equals(HMCCommandUtils.AFFINITY_PARTITION_TYPE)) {
                if (null == this.allResources) {
                    this.hlc = hSCClientObjectFactory.createLPARClient(this.managedSystem, this.name, false);
                    if (null == this.hlc) {
                        string3 = HSCResourceBundleUtil.getMessage("HSCCommonBundle", "PARTITION_NOT_FOUND");
                        throw new HSCException(string3);
                    }
                } else {
                    this.hcc = hSCClientObjectFactory.createCECClient(this.managedSystem, false);
                    hashtable = this.hcc.getLparNames();
                    if (this.resourceType.equals(HMCCommandUtils.PARTITION_TYPE)) {
                        vector3 = (Vector)hashtable.get("LparName");
                    } else if (this.resourceType.equals(HMCCommandUtils.AFFINITY_PARTITION_TYPE)) {
                        vector3 = (Vector)hashtable.get("AlparName");
                    }
                    this.lparClients = new Vector();
                    n = 0;
                    while (n < vector3.size()) {
                        string = (String)vector3.elementAt(n);
                        hSCLPARClient = hSCClientObjectFactory.createLPARClient(this.managedSystem, string, false);
                        if (hSCLPARClient == null) {
                            string3 = HSCResourceBundleUtil.getMessage("HSCCommonBundle", "MANAGED_SYSTEM_NOT_FOUND");
                            throw new HSCException(string3);
                        }
                        this.lparClients.add(hSCLPARClient);
                        ++n;
                    }
                }
            }
            if (this.resourceType.equals(HMCCommandUtils.PROFILE_TYPE)) {
                if (null == this.allResources) {
                    this.hpc = hSCClientObjectFactory.createProfileClient(this.managedSystem, this.sourcePartition, this.name, false);
                    if (null == this.hpc) {
                        string3 = HSCResourceBundleUtil.getMessage("HSCCommonBundle", "PROFILE_NOT_FOUND");
                        throw new HSCException(string3);
                    }
                } else {
                    this.hlc = hSCClientObjectFactory.createLPARClient(this.managedSystem, this.sourcePartition, false);
                    vector2 = this.hlc.getProfileNames();
                    this.profileClients = new Vector();
                    n = 0;
                    while (n < vector2.size()) {
                        string = (String)vector2.elementAt(n);
                        hSCProfileClient = hSCClientObjectFactory.createProfileClient(this.managedSystem, this.sourcePartition, string, false);
                        if (hSCProfileClient == null) {
                            string3 = HSCResourceBundleUtil.getMessage("HSCCommonBundle", "PROFILE_NOT_FOUND");
                            throw new HSCException(string3);
                        }
                        this.profileClients.add(hSCProfileClient);
                        ++n;
                    }
                }
            }
            if (!this.resourceType.equals(HMCCommandUtils.SYSTEM_PROFILE_TYPE)) break block53;
            if (null == this.allResources) {
                this.hspc = hSCClientObjectFactory.createSystemProfileClient(this.managedSystem, this.name, false);
                if (null == this.hspc) {
                    string3 = HSCResourceBundleUtil.getMessage("HSCCommonBundle", "SYSTEM_PROFILE_NOT_FOUND");
                    throw new HSCException(string3);
                }
            } else {
                this.hcc = hSCClientObjectFactory.createCECClient(this.managedSystem, false);
                vector = this.hcc.getSystemProfileNames();
                this.systemProfileClients = new Vector();
                n = 0;
                while (n < vector.size()) {
                    string = (String)vector.elementAt(n);
                    hSCSystemProfileClient = hSCClientObjectFactory.createSystemProfileClient(this.managedSystem, string, false);
                    if (hSCSystemProfileClient == null) {
                        string3 = HSCResourceBundleUtil.getMessage("HSCCommonBundle", "SYSTEM_PROFILE_NOT_FOUND");
                        throw new HSCException(string3);
                    }
                    this.systemProfileClients.add(hSCSystemProfileClient);
                    ++n;
                }
            }
        }
    }

    public void mapParameters(HashMap hashMap) throws RequiredParameterException {
        Object var2_2 = null;
        Object var3_3 = null;
        this.allResources = (String)hashMap.get(HMCCommandUtils.ALL_PARAM);
        this.alternateFormat = (String)hashMap.get(HMCCommandUtils.ALTERNATE_FORMAT_PARAM);
        this.format = (String)hashMap.get(HMCCommandUtils.FORMAT_PARAM);
        this.frameName = (String)hashMap.get(HMCCommandUtils.FRAME_NAME_PARAM);
        this.managedSystem = (String)hashMap.get(HMCCommandUtils.MANAGED_SYSTEM_PARAM);
        this.name = (String)hashMap.get(HMCCommandUtils.NAME_PARAM);
        this.resourceType = (String)hashMap.get(HMCCommandUtils.RESOURCE_TYPE_PARAM);
        this.sourcePartition = (String)hashMap.get(HMCCommandUtils.SOURCE_PARTITION_NAME_PARAM);
    }

    private void printPartitionResults(Vector vector) throws HSCException, RequiredParameterException {
        Hashtable hashtable = null;
        HMCFormatTable hMCFormatTable = null;
        Integer n = null;
        String string = null;
        Integer n2 = null;
        String string2 = null;
        String string3 = null;
        Object var9_9 = null;
        String string4 = null;
        String string5 = null;
        String string6 = null;
        Object var13_13 = null;
        Object var14_14 = null;
        String string7 = null;
        String[] stringArray = null;
        if (this.writeStatus) {
            this.writeStatus = false;
            this.output.print('\u0000');
        }
        if (vector == null || vector.size() == 0) {
            if (null == this.format) {
                this.output.println(HSCResourceBundleUtil.getMessage("HSCCommonBundle", "NO_RESULTS_FOUND"));
            }
        } else {
            Object object;
            if (null == this.format) {
                hMCFormatTable = new HMCFormatTable(6);
                stringArray = new String[]{SystemConfigurationList.getMessage("NAME", "Name"), SystemConfigurationList.getMessage("ID", "id"), SystemConfigurationList.getMessage("DLPAR_CAPABILITY", "DLPAR"), SystemConfigurationList.getMessage("STATE", "State"), SystemConfigurationList.getMessage("PROFILE", "Profile"), SystemConfigurationList.getMessage("COMMAND_LINE_OP_PANEL_VALUE", "OpPanel")};
                hMCFormatTable.addEntry(stringArray);
            }
            int n3 = 0;
            while (n3 < vector.size()) {
                Object object2;
                object = null;
                hashtable = (Hashtable)vector.get(n3);
                n = (Integer)hashtable.get("DlparCapability");
                string2 = (String)hashtable.get("DefaultProfileName");
                string3 = (String)hashtable.get("ActivatedProfileName");
                string5 = (String)hashtable.get("Name");
                string6 = (String)hashtable.get("OpPanelValue");
                object = (Integer)hashtable.get("PartitionState");
                n2 = (Integer)hashtable.get("PartitionType");
                string7 = (String)hashtable.get("ID");
                string = CSPStateText.getStateValue((Integer)object);
                string4 = string7.substring(0, 3);
                if (null != this.format) {
                    object2 = new String[8];
                    Object[] objectArray = new Object[8];
                    String string8 = new String();
                    object2[0] = "dlpar_capability";
                    if (n == 15) {
                        objectArray[0] = "YES";
                    } else if (n == 0) {
                        objectArray[0] = "NO";
                    }
                    object2[1] = "state";
                    objectArray[1] = "" + string;
                    object2[2] = "type";
                    objectArray[2] = n2;
                    object2[3] = "default_profile";
                    objectArray[3] = string2;
                    object2[4] = "activated_profile";
                    objectArray[4] = string3;
                    object2[5] = "name";
                    objectArray[5] = string5;
                    object2[6] = "op_panel_value";
                    objectArray[6] = string6;
                    object2[7] = "id";
                    objectArray[7] = string4;
                    String[] stringArray2 = new String[]{HMCCommandUtils.getFormatDelimiter(this.format, object2, ((String[])object2).length)};
                    String[] stringArray3 = HMCCommandUtils.parseFormatList(this.format, stringArray2[0], object2, ((String[])object2).length);
                    int n4 = 0;
                    while (n4 < stringArray3.length) {
                        int n5 = 0;
                        while (n5 < objectArray.length) {
                            if (stringArray3[n4].equals(object2[n5]) && objectArray[n5] != null) {
                                string8 = string8 + objectArray[n5];
                            }
                            ++n5;
                        }
                        string8 = string8 + stringArray2[0];
                        ++n4;
                    }
                    if (this.oldCommand) {
                        this.outputList.add(string8);
                    } else {
                        this.output.println(string8);
                    }
                } else {
                    object2 = null;
                    if (((Integer)object == 8 || (Integer)object == 6) && string3 != null) {
                        string2 = string3;
                    }
                    stringArray[0] = string5;
                    stringArray[1] = string4;
                    if (n != null) {
                        if (n == 15) {
                            object2 = "YES";
                        } else if (n == 0) {
                            object2 = "NO";
                        }
                    }
                    stringArray[2] = object2;
                    object2 = string != null ? string.toString() : "";
                    stringArray[3] = object2;
                    stringArray[4] = string2;
                    stringArray[5] = string6;
                    hMCFormatTable.addEntry(stringArray);
                }
                ++n3;
            }
            if (this.format == null && hMCFormatTable != null) {
                object = hMCFormatTable.getTable();
                int n6 = 0;
                while (n6 < ((String[])object).length) {
                    this.output.println(object[n6]);
                    ++n6;
                }
            }
        }
    }

    private void printAlternatePartitionResults(Vector vector) {
        Hashtable hashtable = null;
        Integer n = null;
        Integer n2 = null;
        String string = null;
        String string2 = null;
        String string3 = null;
        Object var8_8 = null;
        String string4 = null;
        String string5 = null;
        String string6 = null;
        Object var12_12 = null;
        Object var13_13 = null;
        String string7 = null;
        if (this.writeStatus) {
            this.writeStatus = false;
            this.output.print('\u0000');
        }
        if (vector == null || vector.size() == 0) {
            if (null == this.format) {
                this.output.println(HSCResourceBundleUtil.getMessage("HSCCommonBundle", "NO_RESULTS_FOUND"));
            }
        } else {
            int n3 = 0;
            while (n3 < vector.size()) {
                Integer n4 = null;
                hashtable = (Hashtable)vector.get(n3);
                n = (Integer)hashtable.get("DlparCapability");
                string2 = (String)hashtable.get("DefaultProfileName");
                if (string2 == null) {
                    string2 = "";
                }
                if ((string3 = (String)hashtable.get("ActivatedProfileName")) == null) {
                    string3 = "";
                }
                string5 = (String)hashtable.get("Name");
                string6 = (String)hashtable.get("OpPanelValue");
                if (string6 == null) {
                    string6 = "";
                }
                n4 = (Integer)hashtable.get("PartitionState");
                n2 = (Integer)hashtable.get("PartitionType");
                string7 = (String)hashtable.get("ID");
                string = CSPStateText.getStateValue(n4);
                string4 = string7 != null ? string7.substring(0, 3) : "";
                this.output.println("name=" + string5);
                this.output.println("id=" + string4);
                this.output.println("dlpar_capability=" + n);
                this.output.println("default_profile=" + string2);
                this.output.println("activated_profile=" + string3);
                this.output.println("state=" + string);
                this.output.println("type=" + n2);
                this.output.println("op_panel_value=" + string6);
                if (n3 + 1 < vector.size()) {
                    this.output.println();
                }
                ++n3;
            }
        }
    }

    private void printAffinityPartitionResults(Vector vector) throws HSCException, RequiredParameterException {
        Hashtable hashtable = null;
        HMCFormatTable hMCFormatTable = null;
        String string = null;
        Integer n = null;
        String string2 = null;
        String string3 = null;
        Object var8_8 = null;
        String string4 = null;
        String string5 = null;
        Object var11_11 = null;
        Object var12_12 = null;
        String[] stringArray = null;
        if (this.writeStatus) {
            this.writeStatus = false;
            this.output.print('\u0000');
        }
        if (vector == null || vector.size() == 0) {
            if (null == this.format) {
                this.output.println(HSCResourceBundleUtil.getMessage("HSCCommonBundle", "NO_RESULTS_FOUND"));
            }
        } else {
            Object object;
            if (null == this.format) {
                hMCFormatTable = new HMCFormatTable(5);
                stringArray = new String[]{SystemConfigurationList.getMessage("NAME", "Name"), SystemConfigurationList.getMessage("STATE", "State"), SystemConfigurationList.getMessage("TYPE", "Type"), SystemConfigurationList.getMessage("PROFILE", "Profile"), SystemConfigurationList.getMessage("COMMAND_LINE_OP_PANEL_VALUE", "OpPanel")};
                hMCFormatTable.addEntry(stringArray);
            }
            int n2 = 0;
            while (n2 < vector.size()) {
                Object object2;
                object = null;
                hashtable = (Hashtable)vector.get(n2);
                object = (Integer)hashtable.get("PartitionState");
                n = (Integer)hashtable.get("PartitionType");
                string2 = (String)hashtable.get("DefaultProfileName");
                string3 = (String)hashtable.get("ActivatedProfileName");
                string4 = (String)hashtable.get("Name");
                string5 = (String)hashtable.get("OpPanelValue");
                string = CSPStateText.getStateValue((Integer)object);
                if (null != this.format) {
                    object2 = new String[6];
                    Object[] objectArray = new Object[6];
                    String string6 = new String();
                    object2[0] = "state";
                    objectArray[0] = string;
                    object2[1] = "type";
                    objectArray[1] = n;
                    object2[2] = "default_profile";
                    objectArray[2] = string2;
                    object2[3] = "activated_profile";
                    objectArray[3] = string3;
                    object2[4] = "name";
                    objectArray[4] = string4;
                    object2[5] = "op_panel_value";
                    objectArray[5] = string5;
                    String[] stringArray2 = new String[]{HMCCommandUtils.getFormatDelimiter(this.format, object2, ((String[])object2).length)};
                    String[] stringArray3 = HMCCommandUtils.parseFormatList(this.format, stringArray2[0], object2, ((String[])object2).length);
                    int n3 = 0;
                    while (n3 < stringArray3.length) {
                        int n4 = 0;
                        while (n4 < objectArray.length) {
                            if (stringArray3[n3].equals(object2[n4]) && objectArray[n4] != null) {
                                string6 = string6 + objectArray[n4];
                            }
                            ++n4;
                        }
                        string6 = string6 + stringArray2[0];
                        ++n3;
                    }
                    if (this.oldCommand) {
                        this.outputList.add(string6);
                    } else {
                        this.output.println(string6);
                    }
                } else {
                    object2 = null;
                    if (((Integer)object == 8 || (Integer)object == 6) && string3 != null) {
                        string2 = string3;
                    }
                    stringArray[0] = string4;
                    object2 = string != null ? string.toString() : "";
                    stringArray[1] = object2;
                    object2 = n != null ? n.toString() : "";
                    stringArray[2] = object2;
                    stringArray[3] = string2;
                    stringArray[4] = string5;
                    hMCFormatTable.addEntry(stringArray);
                }
                ++n2;
            }
            if (this.format == null && hMCFormatTable != null) {
                object = hMCFormatTable.getTable();
                int n5 = 0;
                while (n5 < ((String[])object).length) {
                    this.output.println(object[n5]);
                    ++n5;
                }
            }
        }
    }

    private void printAlternateAffinityPartitionResults(Vector vector) {
        Hashtable hashtable = null;
        String string = null;
        Integer n = null;
        String string2 = null;
        String string3 = null;
        Object var7_7 = null;
        String string4 = null;
        String string5 = null;
        Object var10_10 = null;
        Object var11_11 = null;
        if (this.writeStatus) {
            this.writeStatus = false;
            this.output.print('\u0000');
        }
        if (vector == null || vector.size() == 0) {
            if (null == this.format) {
                this.output.println(HSCResourceBundleUtil.getMessage("HSCCommonBundle", "NO_RESULTS_FOUND"));
            }
        } else {
            int n2 = 0;
            while (n2 < vector.size()) {
                Integer n3 = null;
                hashtable = (Hashtable)vector.get(n2);
                n3 = (Integer)hashtable.get("PartitionState");
                n = (Integer)hashtable.get("PartitionType");
                string2 = (String)hashtable.get("DefaultProfileName");
                if (string2 == null) {
                    string2 = "";
                }
                if ((string3 = (String)hashtable.get("ActivatedProfileName")) == null) {
                    string3 = "";
                }
                string4 = (String)hashtable.get("Name");
                string5 = (String)hashtable.get("OpPanelValue");
                if (string5 == null) {
                    string5 = "";
                }
                string = CSPStateText.getStateValue(n3);
                this.output.println("name=" + string4);
                this.output.println("type=" + n);
                this.output.println("default_profile=" + string2);
                this.output.println("activated_profile=" + string3);
                this.output.println("state=" + string);
                this.output.println("op_panel_value=" + string5);
                if (n2 + 1 < vector.size()) {
                    this.output.println();
                }
                ++n2;
            }
        }
    }

    private void printFrameResults(Vector vector) throws HSCException, RequiredParameterException {
        Boolean bl = null;
        Hashtable hashtable = null;
        HMCFormatTable hMCFormatTable = null;
        Integer n = null;
        String string = null;
        Object var7_7 = null;
        String string2 = null;
        String string3 = null;
        String[] stringArray = null;
        Vector vector2 = null;
        if (this.writeStatus) {
            this.writeStatus = false;
            this.output.print('\u0000');
        }
        if (vector == null || vector.size() == 0) {
            if (null == this.format) {
                this.output.println(HSCResourceBundleUtil.getMessage("HSCCommonBundle", "NO_RESULTS_FOUND"));
            }
        } else {
            Object object;
            if (null == this.format) {
                hMCFormatTable = new HMCFormatTable(5);
                stringArray = new String[]{SystemConfigurationList.getMessage("NAME", "Name"), SystemConfigurationList.getMessage("FRAME_NUMBER", "FrameNum"), SystemConfigurationList.getMessage("IS_REAL_FRAME", "IsFrame"), SystemConfigurationList.getMessage("PORT_NUMBERS", "PortNums"), SystemConfigurationList.getMessage("FRAME_TYPE", "FrameType")};
                hMCFormatTable.addEntry(stringArray);
            }
            int n2 = 0;
            while (n2 < vector.size()) {
                hashtable = (Hashtable)vector.get(n2);
                string2 = (String)hashtable.get("frameNumber_PROP");
                bl = (Boolean)hashtable.get("frame_PROP");
                n = (Integer)hashtable.get("frameType_PROP");
                string = (String)hashtable.get("Name");
                vector2 = (Vector)hashtable.get("portNumbers_PROP");
                if (null != this.format) {
                    object = new String[5];
                    Object[] objectArray = new Object[5];
                    String string4 = new String();
                    object[0] = "name";
                    objectArray[0] = string;
                    object[1] = "frame_number";
                    objectArray[1] = string2;
                    object[2] = "is_real_frame";
                    if (bl != null) {
                        objectArray[2] = bl != false ? HSCResourceBundleUtil.getMessage("HSCCommonBundle", "YES") : HSCResourceBundleUtil.getMessage("HSCCommonBundle", "NO");
                    }
                    object[3] = "port_numbers";
                    if (vector2 != null) {
                        string3 = new String();
                        int n3 = 0;
                        while (n3 < vector2.size()) {
                            string3 = string3 + ((Integer)vector2.get(n3)).toString();
                            if (n3 + 1 < vector2.size()) {
                                string3 = string3 + ",";
                            }
                            ++n3;
                        }
                    }
                    objectArray[3] = string3;
                    object[4] = "frame_type";
                    objectArray[4] = n != null ? n.toString() : "";
                    String[] stringArray2 = new String[1];
                    try {
                        stringArray2[0] = HMCCommandUtils.getFormatDelimiter(this.format, object, ((String[])object).length);
                        String[] stringArray3 = HMCCommandUtils.parseFormatList(this.format, stringArray2[0], object, ((String[])object).length);
                        int n4 = 0;
                        while (n4 < stringArray3.length) {
                            int n5 = 0;
                            while (n5 < objectArray.length) {
                                if (stringArray3[n4].equals(object[n5]) && objectArray[n5] != null) {
                                    string4 = string4 + objectArray[n5];
                                }
                                ++n5;
                            }
                            string4 = string4 + stringArray2[0];
                            ++n4;
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (this.oldCommand) {
                        this.outputList.add(string4);
                    } else {
                        this.output.println(string4);
                    }
                } else {
                    object = null;
                    stringArray[0] = string;
                    stringArray[1] = string2;
                    object = bl != null ? (bl.booleanValue() ? HSCResourceBundleUtil.getMessage("HSCCommonBundle", "YES") : HSCResourceBundleUtil.getMessage("HSCCommonBundle", "NO")) : "";
                    stringArray[2] = object;
                    if (vector2 != null) {
                        object = new String();
                        int n6 = 0;
                        while (n6 < vector2.size()) {
                            object = (String)object + ((Integer)vector2.get(n6)).toString();
                            if (n6 + 1 < vector2.size()) {
                                object = (String)object + ",";
                            }
                            ++n6;
                        }
                    } else {
                        object = "";
                    }
                    stringArray[3] = object;
                    object = n != null ? n.toString() : "";
                    stringArray[4] = object;
                    hMCFormatTable.addEntry(stringArray);
                }
                ++n2;
            }
            if (this.format == null && hMCFormatTable != null) {
                object = hMCFormatTable.getTable();
                int n7 = 0;
                while (n7 < ((String[])object).length) {
                    this.output.println(object[n7]);
                    ++n7;
                }
            }
        }
    }

    private void printAlternateFrameResults(Vector vector) {
        Boolean bl = null;
        Hashtable hashtable = null;
        Integer n = null;
        String string = null;
        Object var6_6 = null;
        String string2 = null;
        String string3 = null;
        Vector vector2 = null;
        if (this.writeStatus) {
            this.writeStatus = false;
            this.output.print('\u0000');
        }
        if (vector == null || vector.size() == 0) {
            if (null == this.format) {
                this.output.println(HSCResourceBundleUtil.getMessage("HSCCommonBundle", "NO_RESULTS_FOUND"));
            }
        } else {
            int n2 = 0;
            while (n2 < vector.size()) {
                hashtable = (Hashtable)vector.get(n2);
                string2 = (String)hashtable.get("frameNumber_PROP");
                if (string2 == null) {
                    string2 = "";
                }
                bl = (Boolean)hashtable.get("frame_PROP");
                n = (Integer)hashtable.get("frameType_PROP");
                string = (String)hashtable.get("Name");
                vector2 = (Vector)hashtable.get("portNumbers_PROP");
                this.output.println("name=" + string);
                this.output.println("frame_number=" + string2);
                this.output.println("frame_type=" + n);
                this.output.print("is_real_frame=");
                if (bl != null) {
                    if (bl.booleanValue()) {
                        this.output.println(HSCResourceBundleUtil.getMessage("HSCCommonBundle", "YES"));
                    } else {
                        this.output.println(HSCResourceBundleUtil.getMessage("HSCCommonBundle", "NO"));
                    }
                } else {
                    this.output.println();
                }
                this.output.print("port_numbers=");
                string3 = new String();
                if (vector2 != null && vector2.size() != 0) {
                    int n3 = 0;
                    while (n3 < vector2.size()) {
                        string3 = string3 + ((Integer)vector2.get(n3)).toString();
                        if (n3 + 1 < vector2.size()) {
                            string3 = string3 + ",";
                        }
                        ++n3;
                    }
                    this.output.println(string3);
                } else {
                    this.output.println();
                }
                if (n2 + 1 < vector.size()) {
                    this.output.println();
                }
                ++n2;
            }
        }
    }

    private void printSystemResults(Vector vector) throws HSCException, RequiredParameterException {
        Boolean bl = null;
        Hashtable hashtable = null;
        HMCFormatTable hMCFormatTable = null;
        Integer n = null;
        Integer n2 = null;
        Integer n3 = null;
        Integer n4 = null;
        Integer n5 = null;
        Integer n6 = null;
        Integer n7 = null;
        Object var12_12 = null;
        Integer n8 = null;
        Integer n9 = null;
        Integer n10 = null;
        Integer n11 = null;
        String string = null;
        Object var18_18 = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        String[] stringArray = null;
        if (this.writeStatus) {
            this.writeStatus = false;
            this.output.print('\u0000');
        }
        if (vector == null || vector.size() == 0) {
            if (null == this.format) {
                this.output.println(HSCResourceBundleUtil.getMessage("HSCCommonBundle", "NO_RESULTS_FOUND"));
            }
        } else {
            Object object;
            int n12;
            if (null == this.format) {
                hMCFormatTable = new HMCFormatTable(9);
                stringArray = new String[9];
                n12 = 0;
                stringArray[n12++] = SystemConfigurationList.getMessage("NAME", "Name");
                stringArray[n12++] = SystemConfigurationList.getMessage("CAGE_NUMBER", "CageNum");
                stringArray[n12++] = SystemConfigurationList.getMessage("LMB_SIZE", "LMBSize");
                stringArray[n12++] = SystemConfigurationList.getMessage("MODE", "Mode");
                stringArray[n12++] = SystemConfigurationList.getMessage("STATE", "State");
                stringArray[n12++] = SystemConfigurationList.getMessage("CSP_VERSION", "CSPVersion");
                stringArray[n12++] = SystemConfigurationList.getMessage("MODEL", "Model");
                stringArray[n12++] = SystemConfigurationList.getMessage("COMMAND_LINE_OP_PANEL_VALUE", "OpPanel");
                stringArray[n12++] = SystemConfigurationList.getMessage("SERIAL_NUMBER", "S/N");
                hMCFormatTable.addEntry(stringArray);
            }
            n12 = 0;
            while (n12 < vector.size()) {
                hashtable = (Hashtable)vector.get(n12);
                n = (Integer)hashtable.get("AffinityCapability");
                n4 = (Integer)hashtable.get("CageNumber");
                n2 = (Integer)hashtable.get("CecCapability");
                string = (String)hashtable.get("CspVersion");
                n3 = (Integer)hashtable.get("CuodCapability");
                n5 = (Integer)hashtable.get("CspSurveillancePolicy");
                n6 = (Integer)hashtable.get("LmbSize");
                n7 = (Integer)hashtable.get("Mode");
                string2 = (String)hashtable.get("Model");
                string3 = (String)hashtable.get("Name");
                string4 = (String)hashtable.get("OpPanelValue");
                bl = (Boolean)hashtable.get("PowerOffPolicy");
                n8 = (Integer)hashtable.get("RuntimeCapability");
                n9 = (Integer)hashtable.get("State");
                string5 = (String)hashtable.get("SerialNumber");
                n10 = (Integer)hashtable.get("InstalledCPUCount");
                n11 = (Integer)hashtable.get("InstalledMemory");
                if (null != this.format) {
                    object = new String[17];
                    Object[] objectArray = new Object[17];
                    String string6 = new String();
                    object[0] = "affinity_capability";
                    objectArray[0] = n;
                    object[1] = "cec_capability";
                    objectArray[1] = n2;
                    object[2] = "cage_number";
                    objectArray[2] = n4;
                    object[3] = "csp_surveillance_policy";
                    objectArray[3] = n5;
                    object[4] = "cuod_capability";
                    objectArray[4] = n3;
                    object[5] = "lmb_size";
                    objectArray[5] = n6;
                    object[6] = "total_cpu";
                    objectArray[6] = n10;
                    object[7] = "total_mem";
                    objectArray[7] = n11;
                    object[8] = "mode";
                    objectArray[8] = n7;
                    object[9] = "runtime_capability";
                    objectArray[9] = n8;
                    object[10] = "state";
                    objectArray[10] = CSPStateText.getStateValue(n9);
                    object[11] = "csp_version";
                    objectArray[11] = string;
                    object[12] = "model";
                    objectArray[12] = string2;
                    object[13] = "name";
                    objectArray[13] = string3;
                    object[14] = "op_panel_value";
                    objectArray[14] = string4;
                    object[15] = "serial_number";
                    objectArray[15] = string5;
                    object[16] = "power_off_policy";
                    objectArray[16] = bl != null ? (bl.booleanValue() ? HMCCommandUtils.POWER_OFF_POLICY_ON : HMCCommandUtils.POWER_OFF_POLICY_OFF) : "";
                    String[] stringArray2 = new String[]{HMCCommandUtils.getFormatDelimiter(this.format, object, ((String[])object).length)};
                    String[] stringArray3 = HMCCommandUtils.parseFormatList(this.format, stringArray2[0], object, ((String[])object).length);
                    int n13 = 0;
                    while (n13 < stringArray3.length) {
                        int n14 = 0;
                        while (n14 < objectArray.length) {
                            if (stringArray3[n13].equals(object[n14]) && objectArray[n14] != null) {
                                string6 = string6 + objectArray[n14];
                            }
                            ++n14;
                        }
                        string6 = string6 + stringArray2[0];
                        ++n13;
                    }
                    if (this.oldCommand) {
                        this.outputList.add(string6);
                    } else {
                        this.output.println(string6);
                    }
                } else {
                    object = null;
                    int n15 = 0;
                    stringArray[n15++] = string3;
                    object = n != null ? n.toString() : "";
                    object = n2 != null ? n2.toString() : "";
                    object = n3 != null ? n3.toString() : "";
                    object = n8 != null ? n8.toString() : "";
                    object = n4 != null ? n4.toString() : "";
                    stringArray[n15++] = object;
                    object = n5 != null ? n5.toString() : "";
                    object = n6 != null ? n6.toString() : "";
                    stringArray[n15++] = object;
                    object = n7 != null ? n7.toString() : "";
                    stringArray[n15++] = object;
                    object = n9 != null ? CSPStateText.getStateValue(n9) : "";
                    stringArray[n15++] = object;
                    stringArray[n15++] = string;
                    stringArray[n15++] = string2;
                    stringArray[n15++] = string4;
                    stringArray[n15++] = string5;
                    object = bl != null ? (bl.booleanValue() ? HMCCommandUtils.POWER_OFF_POLICY_ON : HMCCommandUtils.POWER_OFF_POLICY_OFF) : "";
                    hMCFormatTable.addEntry(stringArray);
                }
                ++n12;
            }
            if (this.format == null && hMCFormatTable != null) {
                object = hMCFormatTable.getTable();
                int n16 = 0;
                while (n16 < ((String[])object).length) {
                    this.output.println(object[n16]);
                    ++n16;
                }
            }
        }
    }

    private void printAlternateSystemResults(Vector vector) {
        Boolean bl = null;
        Hashtable hashtable = null;
        Integer n = null;
        Integer n2 = null;
        Integer n3 = null;
        Integer n4 = null;
        Integer n5 = null;
        Integer n6 = null;
        Integer n7 = null;
        Integer n8 = null;
        Integer n9 = null;
        String string = null;
        Object var14_14 = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        String string6 = null;
        if (this.writeStatus) {
            this.writeStatus = false;
            this.output.print('\u0000');
        }
        if (vector == null || vector.size() == 0) {
            if (null == this.format) {
                this.output.println(HSCResourceBundleUtil.getMessage("HSCCommonBundle", "NO_RESULTS_FOUND"));
            }
        } else {
            int n10 = 0;
            while (n10 < vector.size()) {
                hashtable = (Hashtable)vector.get(n10);
                n = (Integer)hashtable.get("AffinityCapability");
                n3 = (Integer)hashtable.get("CageNumber");
                n2 = (Integer)hashtable.get("CecCapability");
                n4 = (Integer)hashtable.get("CspSurveillancePolicy");
                n5 = (Integer)hashtable.get("LmbSize");
                n6 = (Integer)hashtable.get("Mode");
                n7 = (Integer)hashtable.get("RuntimeCapability");
                n8 = (Integer)hashtable.get("State");
                n9 = (Integer)hashtable.get("CuodCapability");
                string = (String)hashtable.get("CspVersion");
                if (string == null) {
                    string = "";
                }
                if ((string2 = (String)hashtable.get("Model")) == null) {
                    string2 = "";
                }
                string3 = (String)hashtable.get("Name");
                string4 = (String)hashtable.get("OpPanelValue");
                if (string4 == null) {
                    string4 = "";
                }
                if ((string5 = (String)hashtable.get("SerialNumber")) == null) {
                    string5 = "";
                }
                bl = (Boolean)hashtable.get("PowerOffPolicy");
                string6 = n8 != null ? CSPStateText.getStateValue(n8) : "";
                this.output.println("name=" + string3);
                this.output.println("state=" + string6);
                this.output.println("model=" + string2);
                this.output.println("serial_number=" + string5);
                this.output.println("affinity_capability=" + n);
                this.output.println("cec_capability=" + n2);
                this.output.println("runtime_capability=" + n7);
                this.output.println("cuod_capability=" + n9);
                this.output.println("power_off_policy=" + bl);
                if (n3 != null) {
                    this.output.println("cage_number=" + n3);
                } else {
                    this.output.println("cage_number=");
                }
                this.output.println("csp_surveillance_policy=" + n4);
                this.output.println("csp_version=" + string);
                this.output.println("mode=" + n6);
                this.output.println("lmb_size=" + n5);
                this.output.println("op_panel_value=" + string4);
                if (n10 + 1 < vector.size()) {
                    this.output.println();
                }
                ++n10;
            }
        }
    }

    private void printProfileResults(Vector vector) throws HSCException, RequiredParameterException {
        Hashtable hashtable = null;
        HMCFormatTable hMCFormatTable = null;
        Integer n = null;
        Integer n2 = null;
        Integer n3 = null;
        Integer n4 = null;
        Integer n5 = null;
        Integer n6 = null;
        Integer n7 = null;
        Integer n8 = null;
        Integer n9 = null;
        Integer n10 = null;
        Integer n11 = null;
        Integer n12 = null;
        String string = null;
        Vector vector2 = null;
        Vector vector3 = null;
        Vector vector4 = null;
        Vector vector5 = null;
        Object var21_21 = null;
        String string2 = null;
        String string3 = null;
        String[] stringArray = null;
        if (this.writeStatus) {
            this.writeStatus = false;
            this.output.print('\u0000');
        }
        if (vector == null || vector.size() == 0) {
            if (null == this.format) {
                this.output.println(HSCResourceBundleUtil.getMessage("HSCCommonBundle", "NO_RESULTS_FOUND"));
            }
        } else {
            Object object;
            int n13;
            if (null == this.format) {
                n13 = 0;
                hMCFormatTable = new HMCFormatTable(8);
                stringArray = new String[8];
                stringArray[n13++] = SystemConfigurationList.getMessage("NAME", "Name");
                stringArray[n13++] = SystemConfigurationList.getMessage("BOOT_MODE", "BootMode");
                stringArray[n13++] = SystemConfigurationList.getMessage("DESIRED_CPU", "DesiredCPU");
                stringArray[n13++] = SystemConfigurationList.getMessage("DESIRED_MEM", "DesiredMEM");
                stringArray[n13++] = SystemConfigurationList.getMessage("MAXIMUM_CPU", "MaxCPU");
                stringArray[n13++] = SystemConfigurationList.getMessage("MAXIMUM_MEM", "MaxMEM");
                stringArray[n13++] = SystemConfigurationList.getMessage("MINIMUM_CPU", "MinCPU");
                stringArray[n13++] = SystemConfigurationList.getMessage("MINIMUM_MEM", "MinMEM");
                hMCFormatTable.addEntry(stringArray);
            }
            n13 = 0;
            while (n13 < vector.size()) {
                hashtable = (Hashtable)vector.get(n13);
                n = (Integer)hashtable.get("BootMode");
                string2 = n == HMCCommandUtils.NORMAL_BOOT_MODE ? HMCCommandUtils.NORMAL_BOOT_MODE_STR : (n == HMCCommandUtils.DIAGNOSTIC_DEFAULT_BOOT_MODE ? HMCCommandUtils.DIAGNOSTIC_DEFAULT_BOOT_MODE_STR : (n == HMCCommandUtils.SMS_BOOT_MODE ? HMCCommandUtils.SMS_BOOT_MODE_STR : (n == HMCCommandUtils.OPEN_FIRMWARE_BOOT_MODE ? HMCCommandUtils.OPEN_FIRMWARE_BOOT_MODE_STR : (n == HMCCommandUtils.DIAGNOSTIC_STORED_BOOT_MODE ? HMCCommandUtils.DIAGNOSTIC_STORED_BOOT_MODE_STR : (n == HMCCommandUtils.STANDBY_BOOT_MODE ? HMCCommandUtils.STANDBY_BOOT_MODE_STR : "")))));
                n2 = (Integer)hashtable.get("DesiredCPUCount");
                n3 = (Integer)hashtable.get("DesiredMemoryMB");
                n4 = (Integer)hashtable.get("MaximumCPUCount");
                n6 = (Integer)hashtable.get("MaximumMemoryMB");
                n5 = (Integer)hashtable.get("MinimumCPUCount");
                n7 = (Integer)hashtable.get("MinimumMemoryMB");
                n8 = (Integer)hashtable.get("ServiceAuthority");
                n9 = (Integer)hashtable.get("SFPSurveillance");
                n10 = (Integer)hashtable.get("RMOSize");
                n11 = (Integer)hashtable.get("SNIConfigMode");
                string = (String)hashtable.get("Name");
                vector2 = (Vector)hashtable.get("Desired_IO");
                vector3 = (Vector)hashtable.get("Required_IO");
                vector5 = (Vector)hashtable.get("SNIDeviceID");
                vector4 = (Vector)hashtable.get("SNIWindows");
                if (null != this.format) {
                    int n14;
                    object = new String[16];
                    Object[] objectArray = new Object[16];
                    String string4 = new String();
                    object[0] = "boot_mode";
                    objectArray[0] = string2;
                    object[1] = "desired_cpu";
                    objectArray[1] = n2;
                    object[2] = "desired_mem";
                    objectArray[2] = n3;
                    object[3] = "maximum_cpu";
                    objectArray[3] = n4;
                    object[4] = "maximum_mem";
                    objectArray[4] = n6;
                    object[5] = "minimum_cpu";
                    objectArray[5] = n5;
                    object[6] = "minimum_mem";
                    objectArray[6] = n7;
                    object[7] = "name";
                    objectArray[7] = string;
                    object[8] = "service_authority";
                    objectArray[8] = n8;
                    object[9] = "sfp_surveillance";
                    objectArray[9] = n9;
                    object[10] = "small_rmo";
                    objectArray[10] = n10;
                    object[11] = "sni_config_mode";
                    objectArray[11] = n11;
                    object[12] = "desired_io";
                    if (vector2 != null) {
                        n14 = 0;
                        while (n14 < vector2.size()) {
                            string3 = (String)vector2.get(n14);
                            if (string3 != null) {
                                objectArray[12] = objectArray[12] + string3;
                                if (n14 + 1 < vector2.size()) {
                                    objectArray[12] = objectArray[12] + ",";
                                }
                            }
                            ++n14;
                        }
                    }
                    object[13] = "required_io";
                    if (vector3 != null) {
                        n14 = 0;
                        while (n14 < vector3.size()) {
                            string3 = (String)vector3.get(n14);
                            if (string3 != null) {
                                objectArray[13] = objectArray[13] + string3;
                                if (n14 + 1 < vector3.size()) {
                                    objectArray[13] = objectArray[13] + ",";
                                }
                            }
                            ++n14;
                        }
                    }
                    object[14] = "sni_device_id";
                    if (vector5 != null) {
                        n14 = 0;
                        while (n14 < vector5.size()) {
                            string3 = (String)vector5.get(n14);
                            if (string3 != null) {
                                objectArray[14] = objectArray[14] + string3;
                                if (n14 + 1 < vector5.size()) {
                                    objectArray[14] = objectArray[14] + ",";
                                }
                            }
                            ++n14;
                        }
                    }
                    object[15] = "sni_windows";
                    if (vector4 != null) {
                        n14 = 0;
                        while (n14 < vector4.size()) {
                            objectArray[15] = objectArray[15] + ((Integer)vector4.get(n14)).toString();
                            if (n14 + 1 < vector4.size()) {
                                objectArray[15] = objectArray[15] + ",";
                            }
                            ++n14;
                        }
                    }
                    String[] stringArray2 = new String[]{HMCCommandUtils.getFormatDelimiter(this.format, object, ((String[])object).length)};
                    String[] stringArray3 = HMCCommandUtils.parseFormatList(this.format, stringArray2[0], object, ((String[])object).length);
                    int n15 = 0;
                    while (n15 < stringArray3.length) {
                        int n16 = 0;
                        while (n16 < objectArray.length) {
                            if (stringArray3[n15].equals(object[n16])) {
                                String string5;
                                int n17;
                                if (stringArray3[n15].equals("desired_io") && vector2 != null) {
                                    n17 = 0;
                                    while (n17 < vector2.size()) {
                                        string5 = (String)vector2.get(n17);
                                        if (string5 != null) {
                                            string4 = string4 + string5;
                                            if (n17 + 1 < vector2.size()) {
                                                string4 = string4 + ",";
                                            }
                                        }
                                        ++n17;
                                    }
                                } else if (stringArray3[n15].equals("required_io") && vector3 != null) {
                                    n17 = 0;
                                    while (n17 < vector3.size()) {
                                        string5 = (String)vector3.get(n17);
                                        if (string5 != null) {
                                            string4 = string4 + string5;
                                            if (n17 + 1 < vector3.size()) {
                                                string4 = string4 + ",";
                                            }
                                        }
                                        ++n17;
                                    }
                                } else if (stringArray3[n15].equals("sni_device_id") && vector5 != null) {
                                    n17 = 0;
                                    while (n17 < vector5.size()) {
                                        string5 = (String)vector5.get(n17);
                                        if (string5 != null) {
                                            string4 = string4 + string5;
                                            if (n17 + 1 < vector5.size()) {
                                                string4 = string4 + ",";
                                            }
                                        }
                                        ++n17;
                                    }
                                } else if (stringArray3[n15].equals("sni_windows") && vector4 != null) {
                                    n17 = 0;
                                    while (n17 < vector4.size()) {
                                        n12 = (Integer)vector4.get(n17);
                                        string4 = string4 + n12.toString();
                                        if (n17 + 1 < vector4.size()) {
                                            string4 = string4 + ",";
                                        }
                                        ++n17;
                                    }
                                } else if (objectArray[n16] != null) {
                                    string4 = string4 + objectArray[n16];
                                }
                            }
                            ++n16;
                        }
                        string4 = string4 + stringArray2[0];
                        ++n15;
                    }
                    if (this.oldCommand) {
                        this.outputList.add(string4);
                    } else {
                        this.output.println(string4);
                    }
                } else {
                    object = null;
                    int n18 = 0;
                    stringArray[n18++] = string;
                    object = n != null ? n.toString() : "";
                    stringArray[n18++] = object;
                    object = n2 != null ? n2.toString() : "";
                    stringArray[n18++] = object;
                    object = n3 != null ? n3.toString() : "";
                    stringArray[n18++] = object;
                    object = n4 != null ? n4.toString() : "";
                    stringArray[n18++] = object;
                    object = n6 != null ? n6.toString() : "";
                    stringArray[n18++] = object;
                    object = n5 != null ? n5.toString() : "";
                    stringArray[n18++] = object;
                    object = n7 != null ? n7.toString() : "";
                    stringArray[n18++] = object;
                    object = n8 != null ? n8.toString() : "";
                    object = n9 != null ? n9.toString() : "";
                    object = n10 != null ? n10.toString() : "";
                    if (vector2 != null) {
                        object = new String();
                        int n19 = 0;
                        while (n19 < vector2.size()) {
                            object = (String)object + (String)vector2.get(n19);
                            if (n19 + 1 < vector2.size()) {
                                object = (String)object + ",";
                            }
                            ++n19;
                        }
                    } else {
                        object = "";
                    }
                    if (vector3 != null) {
                        object = new String();
                        int n20 = 0;
                        while (n20 < vector3.size()) {
                            object = (String)object + (String)vector3.get(n20);
                            if (n20 + 1 < vector3.size()) {
                                object = (String)object + ",";
                            }
                            ++n20;
                        }
                    } else {
                        object = "";
                    }
                    object = n11 != null ? n11.toString() : "";
                    if (vector5 != null) {
                        object = new String();
                        int n21 = 0;
                        while (n21 < vector5.size()) {
                            object = (String)object + (String)vector5.get(n21);
                            if (n21 + 1 < vector5.size()) {
                                object = (String)object + ",";
                            }
                            ++n21;
                        }
                    } else {
                        object = "";
                    }
                    if (vector4 != null) {
                        object = new String();
                        int n22 = 0;
                        while (n22 < vector4.size()) {
                            object = (String)object + ((Integer)vector4.get(n22)).toString();
                            if (n22 + 1 < vector4.size()) {
                                object = (String)object + ",";
                            }
                            ++n22;
                        }
                    } else {
                        object = "";
                    }
                    hMCFormatTable.addEntry(stringArray);
                }
                ++n13;
            }
            if (this.format == null && hMCFormatTable != null) {
                object = hMCFormatTable.getTable();
                int n23 = 0;
                while (n23 < ((String[])object).length) {
                    this.output.println(object[n23]);
                    ++n23;
                }
            }
        }
    }

    private void printAlternateProfileResults(Vector vector) {
        Hashtable hashtable = null;
        Integer n = null;
        Integer n2 = null;
        Integer n3 = null;
        Integer n4 = null;
        Integer n5 = null;
        Integer n6 = null;
        Integer n7 = null;
        Integer n8 = null;
        Integer n9 = null;
        Integer n10 = null;
        Integer n11 = null;
        String string = null;
        Vector vector2 = null;
        Vector vector3 = null;
        Vector vector4 = null;
        Vector vector5 = null;
        Object var19_19 = null;
        String string2 = null;
        Object var21_21 = null;
        if (this.writeStatus) {
            this.writeStatus = false;
            this.output.print('\u0000');
        }
        if (vector == null || vector.size() == 0) {
            if (null == this.format) {
                this.output.println(HSCResourceBundleUtil.getMessage("HSCCommonBundle", "NO_RESULTS_FOUND"));
            }
        } else {
            int n12 = 0;
            while (n12 < vector.size()) {
                int n13;
                hashtable = (Hashtable)vector.get(n12);
                n = (Integer)hashtable.get("BootMode");
                string2 = n == HMCCommandUtils.NORMAL_BOOT_MODE ? HMCCommandUtils.NORMAL_BOOT_MODE_STR : (n == HMCCommandUtils.DIAGNOSTIC_DEFAULT_BOOT_MODE ? HMCCommandUtils.DIAGNOSTIC_DEFAULT_BOOT_MODE_STR : (n == HMCCommandUtils.SMS_BOOT_MODE ? HMCCommandUtils.SMS_BOOT_MODE_STR : (n == HMCCommandUtils.OPEN_FIRMWARE_BOOT_MODE ? HMCCommandUtils.OPEN_FIRMWARE_BOOT_MODE_STR : (n == HMCCommandUtils.DIAGNOSTIC_STORED_BOOT_MODE ? HMCCommandUtils.DIAGNOSTIC_STORED_BOOT_MODE_STR : (n == HMCCommandUtils.STANDBY_BOOT_MODE ? HMCCommandUtils.STANDBY_BOOT_MODE_STR : "N/A")))));
                n2 = (Integer)hashtable.get("DesiredCPUCount");
                n3 = (Integer)hashtable.get("DesiredMemoryMB");
                n4 = (Integer)hashtable.get("MaximumCPUCount");
                n6 = (Integer)hashtable.get("MaximumMemoryMB");
                n5 = (Integer)hashtable.get("MinimumCPUCount");
                n7 = (Integer)hashtable.get("MinimumMemoryMB");
                n8 = (Integer)hashtable.get("ServiceAuthority");
                n9 = (Integer)hashtable.get("SFPSurveillance");
                n10 = (Integer)hashtable.get("RMOSize");
                n11 = (Integer)hashtable.get("SNIConfigMode");
                string = (String)hashtable.get("Name");
                vector2 = (Vector)hashtable.get("Desired_IO");
                vector3 = (Vector)hashtable.get("Required_IO");
                vector5 = (Vector)hashtable.get("SNIDeviceID");
                vector4 = (Vector)hashtable.get("SNIWindows");
                this.output.println(HMCCommandUtils.NAME_ATTR + "=" + string);
                if (n4 != null) {
                    this.output.println(HMCCommandUtils.MAXIMUM_CPU_ATTR + "=" + n4);
                } else {
                    this.output.println(HMCCommandUtils.MAXIMUM_CPU_ATTR + "=");
                }
                if (n6 != null) {
                    this.output.println(HMCCommandUtils.MAXIMUM_MEM_ATTR + "=" + n6);
                } else {
                    this.output.println(HMCCommandUtils.MAXIMUM_MEM_ATTR + "=");
                }
                if (n5 != null) {
                    this.output.println(HMCCommandUtils.MINIMUM_CPU_ATTR + "=" + n5);
                } else {
                    this.output.println(HMCCommandUtils.MINIMUM_CPU_ATTR + "=");
                }
                if (n7 != null) {
                    this.output.println(HMCCommandUtils.MINIMUM_MEM_ATTR + "=" + n7);
                } else {
                    this.output.println(HMCCommandUtils.MINIMUM_MEM_ATTR + "=");
                }
                if (n2 != null) {
                    this.output.println(HMCCommandUtils.DESIRED_CPU_ATTR + "=" + n2);
                } else {
                    this.output.println(HMCCommandUtils.DESIRED_CPU_ATTR + "=");
                }
                if (n3 != null) {
                    this.output.println(HMCCommandUtils.DESIRED_MEM_ATTR + "=" + n3);
                } else {
                    this.output.println(HMCCommandUtils.DESIRED_MEM_ATTR + "=");
                    this.output.println(HMCCommandUtils.BOOT_MODE_ATTR + "=" + string2);
                }
                if (n8 != null) {
                    this.output.println(HMCCommandUtils.SERVICE_AUTHORITY_ATTR + "=" + n8);
                } else {
                    this.output.println(HMCCommandUtils.SERVICE_AUTHORITY_ATTR + "=");
                }
                if (n9 != null) {
                    this.output.println(HMCCommandUtils.SFP_SURVEILLANCE_ATTR + "=" + n9);
                } else {
                    this.output.println(HMCCommandUtils.SFP_SURVEILLANCE_ATTR + "=");
                }
                this.output.println(HMCCommandUtils.SMALL_RMO_ATTR + "=" + n10);
                if (n11 != null) {
                    this.output.println(HMCCommandUtils.SNI_CONFIG_MODE_ATTR + "=" + n11);
                } else {
                    this.output.println(HMCCommandUtils.SNI_CONFIG_MODE_ATTR + "=");
                }
                this.output.print(HMCCommandUtils.SNI_DEVICE_ID_ATTR + "=");
                if (vector5 != null && vector5.size() > 0) {
                    n13 = 0;
                    while (n13 < vector5.size()) {
                        this.output.print(vector5.get(n13));
                        if (n13 + 1 < vector5.size()) {
                            this.output.print(",");
                        } else {
                            this.output.println();
                        }
                        ++n13;
                    }
                } else {
                    this.output.println();
                }
                this.output.print(HMCCommandUtils.SNI_WINDOW_ATTR + "=");
                if (vector4 != null && vector4.size() != 0) {
                    n13 = 0;
                    while (n13 < vector4.size()) {
                        this.output.print(vector4.get(n13));
                        if (n13 + 1 < vector4.size()) {
                            this.output.print(",");
                        } else {
                            this.output.println();
                        }
                        ++n13;
                    }
                } else {
                    this.output.println();
                }
                this.output.print(HMCCommandUtils.DESIRED_IO_ATTR + "=");
                if (vector2 != null && vector2.size() != 0) {
                    n13 = 0;
                    while (n13 < vector2.size()) {
                        this.output.print(vector2.get(n13));
                        if (n13 + 1 < vector2.size()) {
                            this.output.print(",");
                        } else {
                            this.output.println();
                        }
                        ++n13;
                    }
                } else {
                    this.output.println();
                }
                this.output.print(HMCCommandUtils.REQUIRED_IO_ATTR + "=");
                if (vector3 != null && vector3.size() != 0) {
                    n13 = 0;
                    while (n13 < vector3.size()) {
                        this.output.print(vector3.get(n13));
                        if (n13 + 1 < vector3.size()) {
                            this.output.print(",");
                        } else {
                            this.output.println();
                        }
                        ++n13;
                    }
                } else {
                    this.output.println();
                }
                ++n12;
            }
        }
    }

    private void printSystemProfileResults(Vector vector) throws HSCException, RequiredParameterException {
        Hashtable hashtable = null;
        HMCFormatTable hMCFormatTable = null;
        Object var4_4 = null;
        String string = null;
        String[] stringArray = null;
        Vector vector2 = null;
        Vector vector3 = null;
        if (this.writeStatus) {
            this.writeStatus = false;
            this.output.print('\u0000');
        }
        if (vector == null || vector.size() == 0) {
            if (null == this.format) {
                this.output.println(HSCResourceBundleUtil.getMessage("HSCCommonBundle", "NO_RESULTS_FOUND"));
            }
        } else {
            Object object;
            if (null == this.format) {
                hMCFormatTable = new HMCFormatTable(2);
                stringArray = new String[]{SystemConfigurationList.getMessage("NAME", "Name"), SystemConfigurationList.getMessage("PROFILE", "Profile")};
                hMCFormatTable.addEntry(stringArray);
            }
            int n = 0;
            while (n < vector.size()) {
                Object object2;
                String string2;
                hashtable = (Hashtable)vector.get(n);
                string = (String)hashtable.get("Name");
                vector2 = (Vector)hashtable.get("SystemProfilePartitions");
                vector3 = (Vector)hashtable.get("SystemProfileProfiles");
                if (null != this.format) {
                    object = new String[2];
                    String[] stringArray2 = new String[2];
                    string2 = new String();
                    object[0] = "name";
                    stringArray2[0] = string;
                    object[1] = "partition_profile";
                    object2 = new String[]{HMCCommandUtils.getFormatDelimiter(this.format, object, ((String[])object).length)};
                    String[] stringArray3 = HMCCommandUtils.parseFormatList(this.format, object2[0], object, ((String[])object).length);
                    int n2 = 0;
                    while (n2 < stringArray3.length) {
                        int n3 = 0;
                        while (n3 < stringArray2.length) {
                            if (stringArray3[n2].equals(object[n3])) {
                                if (stringArray3[n2].equals("partition_profile") && vector2 != null) {
                                    int n4 = 0;
                                    while (n4 < vector2.size()) {
                                        String string3 = (String)vector2.get(n4);
                                        String string4 = (String)vector3.get(n4);
                                        if (string3 != null && string4 != null) {
                                            string2 = string2 + string3 + "/" + string4;
                                            if (n4 + 1 < vector2.size()) {
                                                string2 = string2 + ", ";
                                            }
                                        }
                                        ++n4;
                                    }
                                } else if (stringArray2[n3] != null) {
                                    string2 = string2 + stringArray2[n3];
                                }
                            }
                            ++n3;
                        }
                        string2 = string2 + object2[0];
                        ++n2;
                    }
                    if (this.oldCommand) {
                        this.outputList.add(string2);
                    } else {
                        this.output.println(string2);
                    }
                } else {
                    object = null;
                    stringArray[0] = string;
                    if (vector2 != null && vector3 != null) {
                        object = new String();
                        int n5 = 0;
                        while (n5 < vector2.size()) {
                            string2 = (String)vector2.get(n5);
                            object2 = (String)vector3.get(n5);
                            object = (String)object + string2 + "/" + (String)object2;
                            if (n5 + 1 < vector2.size()) {
                                object = (String)object + ", ";
                            }
                            ++n5;
                        }
                    } else {
                        object = "";
                    }
                    stringArray[1] = object;
                    hMCFormatTable.addEntry(stringArray);
                }
                ++n;
            }
            if (this.format == null && hMCFormatTable != null) {
                object = hMCFormatTable.getTable();
                int n6 = 0;
                while (n6 < ((String[])object).length) {
                    this.output.println(object[n6]);
                    ++n6;
                }
            }
        }
    }

    private void printAlternateSystemProfileResults(Vector vector) {
        Hashtable hashtable = null;
        Object var3_3 = null;
        String string = null;
        Vector vector2 = null;
        Vector vector3 = null;
        if (this.writeStatus) {
            this.writeStatus = false;
            this.output.print('\u0000');
        }
        if (vector == null || vector.size() == 0) {
            if (null == this.format) {
                this.output.println(HSCResourceBundleUtil.getMessage("HSCCommonBundle", "NO_RESULTS_FOUND"));
            }
        } else {
            int n = 0;
            while (n < vector.size()) {
                int n2;
                hashtable = (Hashtable)vector.get(n);
                string = (String)hashtable.get("Name");
                vector2 = (Vector)hashtable.get("SystemProfilePartitions");
                vector3 = (Vector)hashtable.get("SystemProfileProfiles");
                this.output.println(HMCCommandUtils.NAME_ATTR + "=" + string);
                this.output.print(HMCCommandUtils.SYS_PROF_PARTITION_NAMES_ATTR + "=");
                if (vector2 != null) {
                    n2 = 0;
                    while (n2 < vector2.size()) {
                        this.output.print(vector2.get(n2));
                        if (n2 + 1 < vector2.size()) {
                            this.output.print(", ");
                        } else {
                            this.output.println();
                        }
                        ++n2;
                    }
                } else {
                    this.output.println();
                }
                this.output.print(HMCCommandUtils.SYS_PROF_PROFILE_NAMES_ATTR + "=");
                if (vector3 != null) {
                    n2 = 0;
                    while (n2 < vector3.size()) {
                        this.output.print(vector3.get(n2));
                        if (n2 + 1 < vector3.size()) {
                            this.output.print(", ");
                        } else {
                            this.output.println();
                        }
                        ++n2;
                    }
                } else {
                    this.output.println();
                }
                ++n;
            }
        }
    }

    public void performCommand() throws HSCException, RequiredParameterException {
        this.checkRequiredParameters();
        this.validateParameterValues();
        this.initializeClients();
        if (this.oldCommand) {
            this.outputList = new ArrayList();
        }
        if (this.resourceType.equals(HMCCommandUtils.ALL_TYPE)) {
            this.doAllList();
        } else if (this.resourceType.equals(HMCCommandUtils.AFFINITY_PARTITION_TYPE)) {
            this.doAffinityPartitionList();
        } else if (this.resourceType.equals(HMCCommandUtils.FRAME_TYPE)) {
            this.doFrameList();
        } else if (this.resourceType.equals(HMCCommandUtils.PARTITION_TYPE)) {
            this.doPartitionList();
        } else if (this.resourceType.equals(HMCCommandUtils.PROFILE_TYPE)) {
            this.doProfileList();
        } else if (this.resourceType.equals(HMCCommandUtils.SYSTEM_PROFILE_TYPE)) {
            this.doSystemProfileList();
        } else if (this.resourceType.equals(HMCCommandUtils.SYSTEM_TYPE)) {
            this.doSystemList();
        }
    }

    public void printResults() {
    }

    private void doAllList() throws HSCException, RequiredParameterException {
        this.doFrameList();
        this.doSystemList();
        this.doAffinityPartitionList();
        this.doPartitionList();
        this.doProfileList();
        this.doSystemProfileList();
    }

    private void doAffinityPartitionList() throws HSCException, RequiredParameterException {
        this.doPartitionList();
    }

    private void doPartitionList() throws HSCException, RequiredParameterException {
        HSCLPARClient hSCLPARClient = null;
        Vector<Hashtable> vector = new Vector<Hashtable>();
        if (null != this.allResources || this.resourceType.equals(HMCCommandUtils.ALL_TYPE)) {
            if (this.lparClients.size() > 0) {
                int n = 0;
                while (n < this.lparClients.size()) {
                    hSCLPARClient = (HSCLPARClient)this.lparClients.elementAt(n);
                    if (hSCLPARClient != null) {
                        this.resultTable = hSCLPARClient.getPartitionData();
                        vector.add(this.resultTable);
                    }
                    ++n;
                }
                if (this.alternateFormat != null) {
                    this.printAlternatePartitionResults(vector);
                } else {
                    this.printPartitionResults(vector);
                }
            } else if (this.alternateFormat != null) {
                this.printAlternatePartitionResults(vector);
            } else {
                this.printPartitionResults(vector);
            }
        } else {
            this.resultTable = this.hlc.getPartitionData();
            vector.add(this.resultTable);
            if (this.alternateFormat != null) {
                this.printAlternatePartitionResults(vector);
            } else {
                this.printPartitionResults(vector);
            }
        }
    }

    private void doProfileList() throws HSCException, RequiredParameterException {
        HSCProfileClient hSCProfileClient = null;
        Vector<Hashtable> vector = new Vector<Hashtable>();
        if (null != this.allResources || this.resourceType.equals(HMCCommandUtils.ALL_TYPE)) {
            if (this.profileClients.size() > 0) {
                int n = 0;
                while (n < this.profileClients.size()) {
                    hSCProfileClient = (HSCProfileClient)this.profileClients.elementAt(n);
                    if (hSCProfileClient != null) {
                        this.resultTable = hSCProfileClient.getProfileData();
                        vector.add(this.resultTable);
                    }
                    ++n;
                }
                if (this.alternateFormat != null) {
                    this.printAlternateProfileResults(vector);
                } else {
                    this.printProfileResults(vector);
                }
            } else if (this.alternateFormat != null) {
                this.printAlternateProfileResults(vector);
            } else {
                this.printProfileResults(vector);
            }
        } else {
            this.resultTable = this.hpc.getProfileData();
            vector.add(this.resultTable);
            if (this.alternateFormat != null) {
                this.printAlternateProfileResults(vector);
            } else {
                this.printProfileResults(vector);
            }
        }
    }

    private void doSystemProfileList() throws HSCException, RequiredParameterException {
        HSCSystemProfileClient hSCSystemProfileClient = null;
        Vector<Hashtable> vector = new Vector<Hashtable>();
        if (null != this.allResources || this.resourceType.equals(HMCCommandUtils.ALL_TYPE)) {
            if (this.systemProfileClients.size() > 0) {
                int n = 0;
                while (n < this.systemProfileClients.size()) {
                    hSCSystemProfileClient = (HSCSystemProfileClient)this.systemProfileClients.elementAt(n);
                    if (hSCSystemProfileClient != null) {
                        this.resultTable = hSCSystemProfileClient.getSystemProfileData();
                        vector.add(this.resultTable);
                    }
                    ++n;
                }
                if (this.alternateFormat != null) {
                    this.printAlternateSystemProfileResults(vector);
                } else {
                    this.printSystemProfileResults(vector);
                }
            } else if (this.alternateFormat != null) {
                this.printAlternateSystemProfileResults(vector);
            } else {
                this.printSystemProfileResults(vector);
            }
        } else {
            this.resultTable = this.hspc.getSystemProfileData();
            vector.add(this.resultTable);
            if (this.alternateFormat != null) {
                this.printAlternateSystemProfileResults(vector);
            } else {
                this.printSystemProfileResults(vector);
            }
        }
    }

    private void doSystemList() throws HSCException, RequiredParameterException {
        HSCCECClient hSCCECClient = null;
        Vector vector = new Vector();
        if (null != this.allResources || this.resourceType.equals(HMCCommandUtils.ALL_TYPE)) {
            if (null == this.frameName) {
                if (this.cecClients.size() > 0) {
                    int n = 0;
                    while (n < this.cecClients.size()) {
                        hSCCECClient = (HSCCECClient)this.cecClients.elementAt(n);
                        if (hSCCECClient != null) {
                            this.resultTable = hSCCECClient.getSystemData();
                            vector.add(this.resultTable);
                        }
                        ++n;
                    }
                    if (this.alternateFormat != null) {
                        this.printAlternateSystemResults(vector);
                    } else {
                        this.printSystemResults(vector);
                    }
                } else if (this.alternateFormat != null) {
                    this.printAlternateSystemResults(vector);
                } else {
                    this.printSystemResults(vector);
                }
            } else {
                vector = this.hfc.getAllSystems();
                if (this.alternateFormat != null) {
                    this.printAlternateSystemResults(vector);
                } else {
                    this.printSystemResults(vector);
                }
            }
        } else {
            this.resultTable = this.hcc.getSystemData();
            vector.add(this.resultTable);
            if (this.alternateFormat != null) {
                this.printAlternateSystemResults(vector);
            } else {
                this.printSystemResults(vector);
            }
        }
    }

    private void doFrameList() throws HSCException, RequiredParameterException {
        HSCFrameClient hSCFrameClient = null;
        Vector<Hashtable> vector = new Vector<Hashtable>();
        if (null != this.allResources || this.resourceType.equals(HMCCommandUtils.ALL_TYPE)) {
            if (this.frameClients.size() > 0) {
                int n = 0;
                while (n < this.frameClients.size()) {
                    hSCFrameClient = (HSCFrameClient)this.frameClients.elementAt(n);
                    if (hSCFrameClient != null) {
                        this.resultTable = hSCFrameClient.getFrameAttributes();
                        vector.add(this.resultTable);
                    }
                    ++n;
                }
                if (this.alternateFormat != null) {
                    this.printAlternateFrameResults(vector);
                } else {
                    this.printFrameResults(vector);
                }
            } else if (this.alternateFormat != null) {
                this.printAlternateFrameResults(vector);
            } else {
                this.printFrameResults(vector);
            }
        } else {
            this.resultTable = this.hfc.getFrameAttributes();
            vector.add(this.resultTable);
            if (this.alternateFormat != null) {
                this.printAlternateFrameResults(vector);
            } else {
                this.printFrameResults(vector);
            }
        }
    }

    public void printHelp() {
        if (this.writeStatus) {
            this.writeStatus = false;
            this.output.print('\u0000');
        }
        this.output.println(HSCResourceBundleUtil.getMessage("HSCCommonBundle", "LIST_SYSTEM_CONFIGURATION_HELP"));
    }

    public static void main(String[] stringArray) {
        SystemConfigurationList systemConfigurationList = new SystemConfigurationList(true);
        System.exit(systemConfigurationList.process(stringArray));
    }

    public static List oldCommandMain(String[] stringArray) {
        SystemConfigurationList systemConfigurationList = new SystemConfigurationList(true);
        systemConfigurationList.oldCommand = true;
        if (systemConfigurationList.process(stringArray) != 0) {
            System.exit(1);
        }
        return systemConfigurationList.outputList;
    }

    public static int entryMethod(String[] stringArray) {
        SystemConfigurationList systemConfigurationList = new SystemConfigurationList(false);
        return systemConfigurationList.process(stringArray);
    }

    private int process(String[] stringArray) {
        boolean bl = false;
        ArrayList<String> arrayList = new ArrayList<String>();
        String string = null;
        try {
            String string2 = null;
            if (0 == stringArray.length) {
                this.printHelp();
            }
            int n = 0;
            while (n < stringArray.length) {
                string2 = stringArray[n];
                arrayList.add(string2);
                if (string2.equals(HMCCommandUtils.HELP_PARAM)) {
                    this.printHelp();
                    bl = true;
                    break;
                }
                ++n;
            }
            if (!bl) {
                HashMap hashMap = HMCCommandUtils.parseParameters(arrayList);
                this.mapParameters(hashMap);
                this.performCommand();
            }
        }
        catch (HSCException hSCException) {
            if (this.writeStatus) {
                this.writeStatus = false;
                this.output.print('\u0001');
            }
            if (IDebug.enabled()) {
                hSCException.printStackTrace(this.output);
            }
            if ((string = hSCException.getMessage()) == null) {
                string = HSCResourceBundleUtil.getMessage("HSCCommonBundle", "COMMAND_LINE_ERROR");
            }
            this.output.println(string);
            return 1;
        }
        catch (RequiredParameterException requiredParameterException) {
            if (this.writeStatus) {
                this.writeStatus = false;
                this.output.print('\u0001');
            }
            if (IDebug.enabled()) {
                requiredParameterException.printStackTrace(this.output);
            }
            if ((string = requiredParameterException.getMessage()) == null) {
                string = HSCResourceBundleUtil.getMessage("HSCCommonBundle", "COMMAND_LINE_ERROR_REQUIRED_PARAMETERS");
            }
            this.output.println(string);
            return 1;
        }
        catch (Exception exception) {
            if (this.writeStatus) {
                this.writeStatus = false;
                this.output.print('\u0001');
            }
            if (IDebug.enabled()) {
                exception.printStackTrace(this.output);
            }
            this.output.println(HSCResourceBundleUtil.getMessage("HSCCommonBundle", "COMMAND_LINE_ERROR"));
            return 1;
        }
        if (this.writeStatus) {
            this.writeStatus = false;
            this.output.print('\u0000');
        }
        return 0;
    }

    private static String getMessage(String string, String string2) {
        return HSCResourceBundleUtil.getMessage("HSCCommonBundle", string, string2);
    }
}

